/**
 * 
 */
package com.ejie.ab18a.control;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.ab18a.entidades.Ab18aUsuario;
import com.ejie.ab18a.model.Ab18aIncoherencia;
import com.ejie.ab18a.service.Ab18aPeticionEnvioService;
import com.ejie.ab18a.utils.Ab18aAccesoWS;
import com.ejie.ab18a.utils.Ab18aConvertirJaxb;
import com.ejie.ab18a.utils.Utilidades;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.security.UserCredentials;
import com.ejie.xmlbeans.ServicioObtencionPerfilesUsuarios;

/**
 * @author XXXX
 * 
 */
@Controller
@RequestMapping(value = "incoherencias")
public class Ab18aIncoherenciasController {

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory.getLogger(Ab18aIncoherenciasController.class);

	@Autowired
	private Ab18aPeticionEnvioService ab18aPeticionEnvioService;

	/** Obtiene la JSP del incoherencias **/
	@RequestMapping(value = "viewIncoherencias", method = RequestMethod.GET)
	public String viewMonitor() {
		logger.info("Entramos en el monitor de incoherencias");
		return "ab18aIncoherencias";
	}

	/** Buscamos las peticiones correspondientes a los valores del filtro **/
	@RequestMapping(value = "tabla", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridResponseDto<Ab18aIncoherencia> buscarIncoherencias(@ModelAttribute() Ab18aIncoherencia filtroIncoherencias,
			@ModelAttribute() JQGridRequestDto request, HttpServletRequest httpRequest) {

		HttpSession session = httpRequest.getSession();
		Ab18aUsuario usuario = null;
		if (session.getAttribute("usuario") != null) {
			usuario = (Ab18aUsuario) session.getAttribute("usuario");
		} else {
			UserCredentials userCredentials = null;
			userCredentials = (UserCredentials) SecurityContextHolder.getContext().getAuthentication().getCredentials();
			String dniUsuarioLogeado = Utilidades.calculoLetraDNI(userCredentials.getNif());
			ServicioObtencionPerfilesUsuarios perfil = null;
			usuario = new Ab18aUsuario();
			try {
				String[] params = { "dni" };
				String[] values = { dniUsuarioLogeado };

				String resultado = Ab18aAccesoWS.obtenerInformacionWS("obtenerPerfilesUsuariosOSBUS", params, values);

				Ab18aConvertirJaxb conversion = new Ab18aConvertirJaxb();

				if (resultado != null) {
					perfil = conversion.xmlToPerfiles(resultado);
				}

				if (perfil != null && perfil.getIdUsuario() != 0) {

					usuario.setDni(dniUsuarioLogeado);
					Utilidades.rellenarUsuario(usuario, perfil);

					session.setAttribute("usuario", usuario);
				}
			} catch (Exception e) {
				logger.error("Error al obtener el usuario getInformacionUsuario:\t" + e.getMessage());
			}
		}

		List<Ab18aIncoherencia> listaIncoherencias = new ArrayList<Ab18aIncoherencia>();
		Long recordNum = null;
		try {
			listaIncoherencias = this.ab18aPeticionEnvioService.findIncoherencias(filtroIncoherencias, usuario, request);
			recordNum = this.ab18aPeticionEnvioService.findAllCountIncoherencias(filtroIncoherencias, usuario);
		} catch (Exception e) {
			Ab18aIncoherenciasController.logger.error("Ab18aIncoherenciasController - buscarIncoherencias() - Error al obtener las incoherencias - "
					+ e);
		}

		JQGridResponseDto<Ab18aIncoherencia> response = new JQGridResponseDto<Ab18aIncoherencia>(request, recordNum, listaIncoherencias);
		return response;
	}

	@RequestMapping(value = "deshabilitar", method = RequestMethod.GET)
	public @ResponseBody
	void deshabilitarIncoherencia(@RequestParam(value = "codExpediente", required = true) String codExpediente, HttpServletResponse response) {

		this.ab18aPeticionEnvioService.deshabilitarIncoherencia(codExpediente);
	}
}
